/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.agriculture;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.IFruitTree;
import net.dries007.tfc.api.util.IGrowingPlant;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeBranch;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeLeaves;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeSapling;
import net.dries007.tfc.objects.te.TETickCounter;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockFruitTreeTrunk
extends Block
implements IGrowingPlant {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final Map<IFruitTree, BlockFruitTreeTrunk> MAP = new HashMap<IFruitTree, BlockFruitTreeTrunk>();
    private static final AxisAlignedBB TRUNK_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
    private static final AxisAlignedBB CONNECTION_N_AABB = new AxisAlignedBB(0.3125, 0.375, 0.0, 0.0, 0.625, 0.3125);
    private static final AxisAlignedBB CONNECTION_S_AABB = new AxisAlignedBB(0.3125, 0.375, 0.6875, 0.0, 0.625, 1.0);
    private static final AxisAlignedBB CONNECTION_W_AABB = new AxisAlignedBB(0.0, 0.375, 0.3125, 0.3125, 0.625, 0.6875);
    private static final AxisAlignedBB CONNECTION_E_AABB = new AxisAlignedBB(0.6875, 0.375, 0.3125, 1.0, 0.625, 0.6875);
    private final IFruitTree tree;

    public static BlockFruitTreeTrunk get(IFruitTree tree) {
        return MAP.get(tree);
    }

    public BlockFruitTreeTrunk(IFruitTree tree) {
        super(Material.field_151575_d, Material.field_151575_d.func_151565_r());
        if (MAP.put(tree, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_149711_c(2.0f);
        this.func_149675_a(true);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
        this.tree = tree;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            if (worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c() != BlockFruitTreeBranch.get(this.tree)) continue;
            state = face == EnumFacing.NORTH ? state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(true)) : (face == EnumFacing.SOUTH ? state.func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(true)) : (face == EnumFacing.EAST ? state.func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(true)) : state.func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(true))));
        }
        return state;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        AxisAlignedBB finalAABB = TRUNK_AABB;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            finalAABB = finalAABB.func_111270_a(CONNECTION_N_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            finalAABB = finalAABB.func_111270_a(CONNECTION_S_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            finalAABB = finalAABB.func_111270_a(CONNECTION_W_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            finalAABB = finalAABB.func_111270_a(CONNECTION_E_AABB);
        }
        return finalAABB;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_185477_a(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockFruitTreeTrunk.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TRUNK_AABB);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        super.func_180650_b(worldIn, pos, state, random);
        if (!worldIn.field_72995_K) {
            long hours;
            float temp = ClimateTFC.getActualTemp(worldIn, pos);
            float rainfall = ChunkDataTFC.getRainfall(worldIn, pos);
            TETickCounter te = Helpers.getTE((IBlockAccess)worldIn, pos, TETickCounter.class);
            if (te != null && (double)(hours = te.getTicksSinceUpdate() / 1000L) > (double)this.tree.getGrowthTime() * ConfigTFC.General.FOOD.fruitTreeGrowthTimeModifier && this.tree.isValidForGrowth(temp, rainfall)) {
                te.resetCounter();
                if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                    if (this.getTrunkHeight(worldIn, pos) < 4) {
                        BlockPos missingLeaf = this.getMissingLeaf(worldIn, pos);
                        if (missingLeaf != null) {
                            if (worldIn.func_180495_p(missingLeaf).func_185904_a().func_76222_j()) {
                                worldIn.func_175656_a(missingLeaf, BlockFruitTreeLeaves.get(this.tree).func_176223_P().func_177226_a((IProperty)BlockFruitTreeLeaves.HARVESTABLE, (Comparable)Boolean.valueOf(false)));
                            }
                        } else {
                            worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                            this.levelUpLeaves(worldIn, pos, false);
                        }
                    } else {
                        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != BlockFruitTreeBranch.get(this.tree)) {
                            BlockPos missingLeaf = this.getMissingLeaf(worldIn, pos);
                            if (missingLeaf != null) {
                                if (worldIn.func_180495_p(missingLeaf).func_185904_a().func_76222_j()) {
                                    worldIn.func_175656_a(missingLeaf, BlockFruitTreeLeaves.get(this.tree).func_176223_P().func_177226_a((IProperty)BlockFruitTreeLeaves.HARVESTABLE, (Comparable)Boolean.valueOf(true)));
                                }
                                return;
                            }
                            worldIn.func_175656_a(pos.func_177984_a(), BlockFruitTreeBranch.get(this.tree).func_176223_P());
                            this.levelUpLeaves(worldIn, pos, true);
                            return;
                        }
                        BlockPos missingLeaf = this.getMissingLeaf(worldIn, pos.func_177984_a());
                        if (missingLeaf != null) {
                            if (worldIn.func_180495_p(missingLeaf).func_185904_a().func_76222_j()) {
                                worldIn.func_175656_a(missingLeaf, BlockFruitTreeLeaves.get(this.tree).func_176223_P().func_177226_a((IProperty)BlockFruitTreeLeaves.HARVESTABLE, (Comparable)Boolean.valueOf(true)));
                            }
                            return;
                        }
                        missingLeaf = this.getMissingLeaf(worldIn, pos.func_177984_a(), EnumFacing.NORTH);
                        if (missingLeaf != null) {
                            if (worldIn.func_180495_p(missingLeaf).func_185904_a().func_76222_j()) {
                                worldIn.func_175656_a(missingLeaf, BlockFruitTreeLeaves.get(this.tree).func_176223_P().func_177226_a((IProperty)BlockFruitTreeLeaves.HARVESTABLE, (Comparable)Boolean.valueOf(true)));
                            }
                            return;
                        }
                        missingLeaf = this.getMissingLeaf(worldIn, pos.func_177984_a(), EnumFacing.SOUTH);
                        if (missingLeaf != null) {
                            if (worldIn.func_180495_p(missingLeaf).func_185904_a().func_76222_j()) {
                                worldIn.func_175656_a(missingLeaf, BlockFruitTreeLeaves.get(this.tree).func_176223_P().func_177226_a((IProperty)BlockFruitTreeLeaves.HARVESTABLE, (Comparable)Boolean.valueOf(true)));
                            }
                            return;
                        }
                        List<Object> shuffledList = Arrays.asList((Object[])EnumFacing.field_176754_o.clone());
                        Collections.shuffle(shuffledList, new Random(pos.func_177986_g()));
                        for (EnumFacing enumFacing : shuffledList) {
                            BlockPos branchPos = pos.func_177972_a(enumFacing);
                            if (worldIn.func_180495_p(branchPos).func_177230_c() != BlockFruitTreeBranch.get(this.tree)) {
                                if (worldIn.func_180495_p(branchPos).func_185904_a().func_76222_j()) {
                                    worldIn.func_175656_a(branchPos, BlockFruitTreeBranch.get(this.tree).func_176223_P());
                                }
                                return;
                            }
                            BlockPos missingLeaf2 = this.getMissingLeaf(worldIn, branchPos, enumFacing);
                            if (missingLeaf2 == null || !worldIn.func_180495_p(missingLeaf2).func_185904_a().func_76222_j()) continue;
                            worldIn.func_175656_a(missingLeaf2, BlockFruitTreeLeaves.get(this.tree).func_176223_P().func_177226_a((IProperty)BlockFruitTreeLeaves.HARVESTABLE, (Comparable)Boolean.valueOf(true)));
                            return;
                        }
                    }
                }
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockFruitTreeTrunk) && !BlocksTFC.isGrowableSoil(worldIn.func_180495_p(pos.func_177977_b()))) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TETickCounter tile = Helpers.getTE((IBlockAccess)worldIn, pos, TETickCounter.class);
        if (tile != null) {
            tile.resetCounter();
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            BlockFruitTreeBranch branch = BlockFruitTreeBranch.get(this.tree);
            if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == branch) {
                worldIn.func_175655_b(pos.func_177984_a(), true);
            }
            if (worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() == branch) {
                worldIn.func_175655_b(pos.func_177984_a(), true);
            }
            if (worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() == branch) {
                worldIn.func_175655_b(pos.func_177984_a(), true);
            }
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() == branch) {
                worldIn.func_175655_b(pos.func_177984_a(), true);
            }
            if (worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() == branch) {
                worldIn.func_175655_b(pos.func_177984_a(), true);
            }
        }
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, SOUTH, EAST, WEST});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TETickCounter();
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)BlockFruitTreeSapling.get(this.tree));
    }

    @Nonnull
    public IFruitTree getTree() {
        return this.tree;
    }

    private BlockPos getMissingLeaf(World world, BlockPos branchPos, EnumFacing branchFacing) {
        if (world.func_180495_p(branchPos.func_177972_a(branchFacing)).func_177230_c() != BlockFruitTreeLeaves.get(this.tree)) {
            return branchPos.func_177972_a(branchFacing);
        }
        List<BlockPos> positions = Arrays.asList(branchPos.func_177972_a(branchFacing.func_176746_e()), branchPos.func_177972_a(branchFacing.func_176746_e().func_176734_d()), branchPos.func_177972_a(branchFacing).func_177972_a(branchFacing.func_176746_e()), branchPos.func_177972_a(branchFacing).func_177972_a(branchFacing.func_176746_e().func_176734_d()));
        Collections.shuffle(positions);
        for (BlockPos pos : positions) {
            if (world.func_180495_p(pos).func_177230_c() == BlockFruitTreeLeaves.get(this.tree)) continue;
            return pos;
        }
        return null;
    }

    @Nullable
    private BlockPos getMissingLeaf(World world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177972_a(EnumFacing.UP)).func_177230_c() != BlockFruitTreeLeaves.get(this.tree)) {
            return pos.func_177972_a(EnumFacing.UP);
        }
        List<Object> shuffledList = Arrays.asList((Object[])EnumFacing.field_176754_o.clone());
        Collections.shuffle(shuffledList);
        for (EnumFacing enumFacing : shuffledList) {
            if (world.func_180495_p(pos.func_177972_a(enumFacing)).func_177230_c() == BlockFruitTreeLeaves.get(this.tree)) continue;
            return pos.func_177972_a(enumFacing);
        }
        return null;
    }

    private void levelUpLeaves(World world, BlockPos oldCenter, boolean hasvestable) {
        BlockPos missingLeaf;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (world.func_180495_p(oldCenter.func_177972_a(facing)).func_177230_c() != BlockFruitTreeLeaves.get(this.tree)) continue;
            world.func_175698_g(oldCenter.func_177972_a(facing));
        }
        while ((missingLeaf = this.getMissingLeaf(world, oldCenter.func_177984_a())) != null && world.func_180495_p(missingLeaf).func_185904_a().func_76222_j()) {
            world.func_175656_a(missingLeaf, BlockFruitTreeLeaves.get(this.tree).func_176223_P().func_177226_a((IProperty)BlockFruitTreeLeaves.HARVESTABLE, (Comparable)Boolean.valueOf(hasvestable)));
            if (missingLeaf != null) continue;
        }
    }

    private int getTrunkHeight(World world, BlockPos pos) {
        for (int i = 1; i < 4; ++i) {
            if (world.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) continue;
            return i;
        }
        return 4;
    }

    @Override
    public IGrowingPlant.GrowthStatus getGrowingStatus(IBlockState state, World world, BlockPos pos) {
        float rainfall;
        float temp = ClimateTFC.getActualTemp(world, pos);
        boolean canGrow = this.tree.isValidForGrowth(temp, rainfall = ChunkDataTFC.getRainfall(world, pos));
        if (canGrow) {
            return IGrowingPlant.GrowthStatus.GROWING;
        }
        return IGrowingPlant.GrowthStatus.NOT_GROWING;
    }
}

